/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.client.renderers.datas;

import fr.iglee42.evolvedmekanism.client.renderers.datas.CustomRenderData;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraftforge.fluids.FluidStack;

@NothingNullByDefault
public class FluidRenderData
extends CustomRenderData {
    public final FluidStack fluidType;

    public FluidRenderData(BlockPos renderLocation, float width, float height, float length, FluidStack fluidType) {
        super(renderLocation, width, height, length);
        this.fluidType = fluidType;
    }

    @Override
    public boolean isGaseous() {
        return MekanismUtils.lighterThanAirGas((FluidStack)this.fluidType);
    }

    public int getColorARGB() {
        return MekanismRenderer.getColorARGB((FluidStack)this.fluidType);
    }

    @Override
    public int getColorARGB(float scale) {
        return MekanismRenderer.getColorARGB((FluidStack)this.fluidType, (float)scale);
    }

    @Override
    public int calculateGlowLight(int light) {
        return MekanismRenderer.calculateGlowLight((int)light, (FluidStack)this.fluidType);
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return MekanismRenderer.getFluidTexture((FluidStack)this.fluidType, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fluidType.getFluid(), this.fluidType.getTag());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object data) {
        if (!super.equals(data)) return false;
        if (!(data instanceof FluidRenderData)) return false;
        FluidRenderData other = (FluidRenderData)data;
        if (!this.fluidType.isFluidEqual(other.fluidType)) return false;
        return true;
    }
}

